/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.operators.arithmetic;

import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.Expression;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.operators.AbstractOperator;
import com.ezylang.evalex.operators.InfixOperator;
import com.ezylang.evalex.parser.Token;
import java.math.BigDecimal;

@InfixOperator(precedence=30)
public class InfixDivisionOperator
extends AbstractOperator {
    @Override
    public EvaluationValue evaluate(Expression expression, Token operatorToken, EvaluationValue ... operands) throws EvaluationException {
        EvaluationValue leftOperand = operands[0];
        EvaluationValue rightOperand = operands[1];
        if (leftOperand.isNumberValue() && rightOperand.isNumberValue()) {
            if (rightOperand.getNumberValue().equals(BigDecimal.ZERO)) {
                throw new EvaluationException(operatorToken, "Division by zero");
            }
            return new EvaluationValue(leftOperand.getNumberValue().divide(rightOperand.getNumberValue(), expression.getConfiguration().getMathContext()));
        }
        throw EvaluationException.ofUnsupportedDataTypeInOperation(operatorToken);
    }
}

